/* This program generates a file of particle number density as a function of particle size*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
void gnu(){printf("\n\n\
Copyright (C) 2002  Edwin W. Eloranta \n\
\n\
For more information contact:\n\
 Ed Eloranta\n\
 University of Wisconsin-Madison\n\
 1225 W. Dayton St.\n\
 Madison, WI 53706\n\
 eloranta@lidar.ssec.wisc.edu\n\
\n\
This program is free software; you can redistribute it and/or\n\
modify it under the terms of the GNU General Public License\n\
as published by the Free Software Foundation; either version 2\n\
of the License, or (at your option) any later version.\n\
\n\
This program is distributed in the hope that it will be useful,\n\
but WITHOUT ANY WARRANTY; without even the implied warranty of\n\
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n\
GNU General Public License for more details.\n\
\n\
You should have received a copy of the GNU General Public License\n\
along with this program; if not, write to the Free Software\n\
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.\n\n");
}

void usage(){
 printf("usage for log-normal distribution:\n size_dist '--lognm', start_size end_size size_inc r_eff beta_c gamma output_file_name \n\n");

 printf("usage for gamma distribution:\n size_dist '--gamma', start_size end_size size_inc r_eff beta_c alpha,gamma output_file_name \n\n type 'size_dist --help' for help\n\n");
}
void help(){
 printf("\nCommand line parameters: \n\
\n\
 size distribution: \n\
                   '--lognm' for log-normal(don't include ' ')\n\
                   '--gamma' for gamma(don't include ' ')\n\
\n\
 smallest_size= smallest size particle in microns.\n\
 largest_size = largest size particle in microns.\n\
 size_inc     = particle size increment in microns.\n\
 r_eff        = effective radius in microns.\n\
 beta_c       = scattering cross section (1/m).\n\
 alpha        = power law parameter in the gamma distribution.\n\
 gamma        = power in exponential of gamma dist. or the width of the lognm dist.\n\
              = see (Deirmendjian 1969, Elsevier NY)for definitions of gamma dist.\n\
This code uses the large particle approximation, Q=2, to normalize particle number\n\
density with the scattering cross section, beta_c.\n\
\n\
The extension .siz will be added to the supplied output filename. This will contain\n\
a table of particle sizes and number densities.\n\
\n");
 
  }




int main(int argc,char *argv[]){
 FILE *fp;
 char mode[8];
 char output_file_name[50];
 char file_ext[5];
 float smallest_size,largest_size,inc,r_eff,alpha=0;
 float beta_c,gamma_l;
 float number ,radius, norm, logfac;
 double p3,p4,a,b;
 int i, n=8;
 /*assign input parameters to variable names*/
 if(argc ==1){printf("FAILED TO SUPPLY INPUT  PARAMETERS \n");
   usage(); 
   exit(3);
   }
 

strncpy(mode,argv[1],8);
 mode[7]=0; /*insure that string is null terminated*/
/*check for help request*/
 if(!strcmp(mode, "--help")){
   usage();
   help();
   exit(2);
   }
 /*check for request of GNU info*/
 if(!strcmp(mode,"-w")){
   gnu();
   exit(0);
   }
/*printf("npar=%i arg[1]=%s\n",argc,argv[1]);*/
 if(!strcmp(mode,"--lognm")){
   if(argc !=9){
     printf("\n ICORRECT NUMBER OF INPUT PARAMETERS FOR LOG-NORMAL DISTRIBUTION\n");
     usage();
     exit(0);
     }
   }
 else if(!strcmp(mode,"--gamma")){
   if(argc !=10){
     printf("\n ICORRECT NUMBER OF INPUT PARAMETERS FOR GAMMA DISTRIBUTION\n");
     usage();
     exit(0);
     }
   }
   else{
   printf("\n PARTICLE SIZE DISCRIPTOR MUST BE '--lognm' or '--gamma'\n");
   exit(0);
   }

printf("\nsize_dist.c version 0.9, Copyright (C) 2002 Ed Eloranta \n\
size_dist comes with ABSOLUTELY NO WARRANTY; for details\n\
type `size_dist -w'.  This is free software, and you are welcome\n\
to redistribute it under the conditions of the GNU General Public License.\n\n");



 
 /* get command line parameters and convert microns to meters*/
 smallest_size=atof(argv[2])*1e-6;
 largest_size=atof(argv[3])*1e-6;
 inc=atof(argv[4])*1e-6;
 r_eff=atof(argv[5])*1e-6;
 beta_c=atof(argv[6]);
 gamma_l=atof(argv[7]);
 
 
 if(!strcmp(mode,"--gamma")){
   alpha=atof(argv[8]);
   n=9;
   }
 if(strlen(argv[n])>40){
   printf("OUTPUT FILE NAME IS TOO LONG(ie >40 characters) \n");
   usage();
   exit(4);
   }
 strncpy(output_file_name,argv[n],40);
 strcpy(file_ext,".siz");
 strcat(output_file_name,file_ext);
     printf("Output data written to file=%s \n\n",output_file_name); 
     /*printf("mode=%s smallest_size=%e largest_size=%e inc=%e r_eff=%e 
       alpha=%e beta_c=%f gamma=%e  output_file_name=%s \n", 
       mode,smallest_size,largest_size,inc,r_eff,alpha,beta_c,gamma_l,
       output_file_name);*/


 /*Open output file and store header info*/

 if ((fp = fopen(output_file_name,"w"))==NULL) {
   printf("ERROR OPENING OUTPUT FILE '%s'\n",output_file_name);
   exit(9);
   }

 /*print header in output file*/
 fprintf(fp,"# Paticle numbers vs size.\n");
 fprintf(fp,"# The following command string created this file:\n#           ");
 for (i=0;i<argc;i++) fprintf(fp," %s",argv[i]);
 fprintf(fp,"\n");
 if(!strcmp(mode,"--lognm")) fprintf(fp,"# Log-Normal size distribution\n");
  else if(!strcmp(mode,"--gamma")) fprintf(fp,"# Gamma size distribution\n"); 
 fprintf(fp,"# beta_c =%9.2e 1/m \n",beta_c);
 fprintf(fp,"# r_eff  =%9.2e microns\n",r_eff*1e6);
 fprintf(fp,"# gamma  =%9.2e \n",gamma_l);
 if(!strcmp(mode,"--gamma")) fprintf(fp,"# alpha  =%9.2e \n",alpha);
 fprintf(fp,"# particles are assumed large compared to the wavelength such that, Q=2\n");
 fprintf(fp,"#\n# radius(um) number/cm^3/micron\n");

 /* compute size distribution*/
 if(!strcmp(mode,"--lognm")){
   alpha=r_eff*exp(-2.5*pow(gamma_l,2));
   a=beta_c/(2*M_PI*pow(alpha,2));
   a=a*exp(-2*pow(gamma_l,2));
   norm=a/(sqrt(2*M_PI)*gamma_l);
   for(radius=smallest_size;radius<=largest_size;radius=radius+inc){
      logfac=pow((log(radius/alpha)/gamma_l),2);
      number=(norm/radius)*exp(-logfac/2);
      /*printf("radius=%f norm=%e gamma=%f logfac=%f number=%e \n"
	,radius*1.e6,norm,gamma_l,logfac,number*1e-6);*/
      /*print to file after converting radius to microns and number to 1/cm^3/micron */
      fprintf(fp,"  %9.2e     %9.2e\n",radius*1e6, number*1e-12);
      }
   }
 else if(!strcmp(mode,"--gamma")){
   for(radius=smallest_size;radius<=largest_size;radius=radius+inc){
      p3=(alpha+3)/gamma_l;
      p4=(alpha+4)/gamma_l;
      b=(1/r_eff)*exp(lgamma(p4))/exp(lgamma(p3));
      b=pow(b,gamma_l);    
      a=beta_c*gamma_l*pow(b,p3)/(2*M_PI*exp(lgamma(p3)));
         /* printf("beta_c=%e b=%e pow(b,p3)=%e exp(lgamma(p3))=%e\n"
             ,beta_c,b,pow(b,p3),exp(lgamma(p3))); */
      number=a*pow(radius,alpha)*exp(-b*pow(radius,gamma_l));
          /*printf("radius=%e number=%e, b=%e, p3=%e a=%e gamma=%e expon=%e\n"
	  ,radius,number,b,p3,a,gamma_l,b*pow(radius,gamma_l))*/;
      /*print to file after converting radius to microns and number to 1/cm^3/micron */
      fprintf(fp,"  %9.2e     %9.2e\n",radius*1e6, number*1e-12);
      }
   }

 fprintf(fp,"\n"); 
 fclose(fp);
 return(0);
 }

