#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include "ms_size_int_c.h"
#include "ms_int_c.h"

#define MAXDIM 6000
 
void gnu(){printf("\n\
Copyright (C) 2002  Edwin W. Eloranta and Joseph P. Garcia \n\
\n\
For more information contact:\n\
 Ed Eloranta\n\
 University of Wisconsin-Madison\n\
 1225 W. Dayton St.\n\
 Madison, WI 53706\n\
 eloranta@lidar.ssec.wisc.edu\n\
\n\
This program is free software; you can redistribute it and/or\n\
modify it under the terms of the GNU General Public License\n\
as published by the Free Software Foundation; either version 2\n\
of the License, or (at your option) any later version.\n\
\n\
This program is distributed in the hope that it will be useful,\n\
but WITHOUT ANY WARRANTY; without even the implied warranty of\n\
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n\
GNU General Public License for more details.\n\
\n\
You should have received a copy of the GNU General Public License\n\
along with this program; if not, write to the Free Software\n\
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.\n\n");
}
void usage(){
 printf("usage:\n mscat data_file_name ['--monod','--lognm','--gamma'] n_orders start_range end_range inc laser_div receiver_fov lambda output_file_name \n\n type 'mscat --help' for help\n\n");
}

void help(){
  printf("\nCommand line parameters:\n\
data_file_name:    A file with input data. For a description type 'mscat df' \n\
\n\
size distribution: '--monod' for mono-disperse\n\
                   '--lognm' for log-normal\n\
                   '--gamma' for gamma\n\
\n\
n_orders:          Number of scattering orders to compute.\n\
\n\
start_range:       Begin calculations at this range.\n\
\n\
end_range:         Do not perform calculations beyond this range.\n\
\n\
inc:               Number of points to increment between computations.\n\
                   When this is set to 1 computations will be performed\n\
                   for each range point in the specified range interval.\n\
                   When inc=2 values will be computed at every other\n\
                   point and with inc=3 every third point etc.\n\
                   The routine still uses all data points in the integration\n\
                   in order to preserve accuracy.\n\
\n\
laser_div:         The 1/e full angular divergence of the laser in radians.\n\
\n\
receiver_fov:      The full-angle field-of-view of the receiver in radians.\n\
\n\
lambda:            The wavelength in microns.\n\
\n\
output_file_name:  Output data will be written to this file--the file name\n\
                   will have an extention '.msc' added to the supplied name.\n\n");
}

void input_data_format(){
printf("\n\n\nData must be supplied in an ascii file.  Three file formats can \n\
be supplied depending on the size distribution.  For log-normal distributions\n\ 
the file extention must be '.lgn'.  For gamma distributions the extention \n\
must be '.gam'. In the mono-disperse mode the routine will accept extentions of \n\
'.mnd', '.lgn' or '.gam'.  Comment lines designated with a # in column 1 may\n\
preceed data.  Data must be supplied in columns seperated by spaces.\n\
Lines must be ended with a carriage return.  \n\
\n\
1) The first column must provide equally spaced values of the range in\n\
meters.  The integration will be preformed using these ranges as\n\
quadrature points.  Coarse range increments will lead to large\n\
integration errors and excessively fine increments will produce long\n\
execution times.\n\
\n\
2) The second column must provide the particulate scattering cross\n\
section corresponding to the ranges listed in column 1. It must be\n\
supplied in units of 1/m (notice this is the scattering cross\n\
section--not the backscatter cross section).  \n\
\n\
3) The third column must provide the Raleigh scattering cross section\n\
corresponding to the ranges listed in column 1. It must be supplied in\n\
units of 1/m. This is only used to compute the Rayleigh lidar return\n\
in the presence of mutlitple scattering.  Supplying zeros in this\n\
column will not effect the computed multiple scatter ratios--only the\n\
computed Rayleigh return will be effected.  \n\
\n\
4) The fourth column must provide the effective radius of cloud\n\
particles at ranges listed in column 1. It must be supplied in units\n\
of microns.  For a monodisperse particle size distribution this will\n\
be used to compute a 1/e angular half-width of the diffraction peak,\n\
theta_s, from the following: theta_s=lambda/(pi*eff_radius) \n\
\n\
5) The fifth column will be ignored in the 'monod' mode and may\n\
be omitted in this mode. It will specify the parameter 'gamma' in a\n\
file describing a log-normal distribution. In a file specifying a\n\
gamma distribution the this column will specifiy the parameter 'alpha.\n\
It must be supplied at each of the ranges specified in column 1.  The\n\
particle size distributions are diffined as: 'monod'\n\
n(r)=delta_function(r_eff)\n\
\n\
               beta*exp(3*gamma^2)       (  1|log(r*exp(2.5*gamma^2)/r_eff)|^2)\n\
 'lognm' n(r)=-----------------------*exp(- -|-----------------------------|  )  \n\
           (2*pi)^(3/2)*r_eff^2*gamma*r  (  2|           gamma             |  )\n\
\n\
 'gamma'            n(r)=\n\
\n\
6) The sixth column will be ignored in the 'monod' and 'lognm' \n\
   modes and it is optional under these modes. It the provides the \n\
   parameter 'gamma' in a file specifying a gamma distribution.\n\
    \n\
   \n\
   a sample of file_name.gam follows:\n\
\n\
# any text you wish \n\
# in an abitrary number of text lines preceeded by # in column 1.......\n\
# range(m) beta_a(1/m) beta_m(1/m) r_eff(microns) alpha gamma  \n\
15         0            1e-6        20             1       5\n\
30         1e-2         .99e-6      21             1.1     5.1\n\
45         1.1e-2       .98e-6      19             .9      5.5\n\
etc \n");
}

 FILE *fp;
 char mode[8];
 char InputStr[128],data_file_name[50],output_file_name[50];
 char header1[40],header2[40],header3[40];
 char file_ext[5];
 double ms[MAXDIM][8];
 double Rayleigh=0;
 double u[18];     /* non-dimensional particle radius=u=constant*radius/r_eff */
 double ranges[MAXDIM], beta_s[MAXDIM],beta_m[MAXDIM],r_eff[MAXDIM],alpha[MAXDIM];
 double gamma_local[MAXDIM],ln_alpha[MAXDIM];
 double tau_c[MAXDIM],tau_t[MAXDIM];
 double fact_m_one[8]={1,1,1,2,6,24,120,720}; /*factorial of N-1 for N=0->6*/
 double fovr2; 
 double dr, divlr2; 
 float start_range,end_range,laser_div,receiver_fov,lambda;
 int   start_pt,last_pt;
 double sum;
 int inc,N,norders;
 int i,n,npts;
 int nu=0;


int main(int argc,char *argv[]){


 /*assign input parameters to variable names*/
 if(argc ==1){printf("FAILED TO SUPPLY INPUT  PARAMETERS \n");
   usage(); 
   exit(3);
 }

 if(strlen(argv[1])>40){
   printf("INPUT FILE NAME IS TOO LONG(ie >40 characters) \n");
   usage();
   exit(1);
 }

 strncpy(data_file_name,argv[1],40);
    /*strcpy(file_ext,".dat"); 
    strcat(data_file_name,file_ext);*/

 /*check for help request*/
 if(!strcmp(data_file_name, "--help")){
   usage();
   help();
   exit(2);
   }
 /*check for request of GNU info*/
 if(!strcmp(data_file_name,"-w")){
   gnu();
   exit(0);
   }
 /*check for help on input file format*/
 if(!strcmp(data_file_name, "--df")){
   input_data_format();
   exit(3);
   }

 /*test to see that all 10 input parameters were supplied*/
 if(argc !=11){printf("WRONG NUMBER OF INPUT PARAMETERS \n");
   usage(); 
   exit(3);
 }

 
 strncpy(mode,argv[2],8);
 mode[7]=0; /*insure that string is null terminated*/
 norders=atoi(argv[3]);
 start_range=atof(argv[4]);
 end_range=atof(argv[5]);
 inc=atoi(argv[6]);
 laser_div=atof(argv[7]);
 receiver_fov=atof(argv[8]);
 lambda=atof(argv[9]);
 if(strlen(argv[10])>40){
   printf("OUTPUT FILE NAME IS TOO LONG(ie >40 characters) \n");
   usage();
   exit(4);
 }

 strncpy(output_file_name,argv[10],40);
 strcpy(file_ext,".msc");
 strcat(output_file_name,file_ext);
 /*printf("file_ext=%s data_file_name=%s \n",file_ext,data_file_name);*/ 
 printf("data_file_name=%s mode=%s norders=%i start_range=%f end_range=%f inc=%i laser_div=%f receiver_fov=%f lambda=%f output_file_name=%s \n"
           ,data_file_name,mode,norders,start_range,end_range,inc,laser_div,receiver_fov
            ,lambda,output_file_name);

 
 /*fetch data file and load arrays with values from file*/
 if ((fp = fopen(data_file_name,"r"))==NULL) {
     printf("\nDATA FILE '%s' NOT FOUND\n\n",data_file_name);
     input_data_format();
     exit(5);
 }

 
 if (!strcmp(mode,"--gamma")){
   printf("\n\n GAMMA DISTRIBUTION NOT IMPLEMENTED IN THIS VERION OF MSCAT\n\n");
   exit(0);
   }


printf("\nscat.c version 0.9, Copyright (C) 2002 Ed Eloranta \n\
mscat comes with ABSOLUTELY NO WARRANTY; for details\n\
type `size_dist -w'.  This is free software, and you are welcome\n\
to redistribute it under the conditions of the GNU General Public License.\n\n");




 npts=0;
 while(!feof(fp)){
   if(fgets(InputStr, 126, fp)){
      printf("%s",InputStr);
      if(InputStr[0] != 35){           /*skip lines beginning with #*/
	 if (!strcmp(mode,"--monod"))
             sscanf(InputStr, "%lf%lf%lf%lf",
                &ranges[npts],&beta_s[npts],&beta_m[npts]
               ,&r_eff[npts]);

         else if (!strcmp(mode,"--lognm")){
             sscanf(InputStr, "%lf%lf%lf%lf%lf",
                &ranges[npts],&beta_s[npts],&beta_m[npts]
               ,&r_eff[npts],&gamma_local[npts]);
	     }  
	 else if (!strcmp(mode,"--gamma")){
             sscanf(InputStr, "%lf%lf%lf%lf%lf%lf",
               &ranges[npts],&beta_s[npts],&beta_m[npts]
               ,&r_eff[npts],&alpha[npts],&gamma_local[npts]);
	     /*printf("npts=%i,range=%g, beta_s=%f, beta_m=%f, r_eff=%f, alpha=%f
               ,gamma=%f \n",npts,ranges[npts],beta_s[npts],beta_m[npts],r_eff[npts]
               ,alpha[npts],gamma_local[npts]);*/
	     }
         else {
           printf("\n size distribution error--choose '--monod', '--lognm' or '--gamma'\n\n");
           exit(6);
	 }
        npts=npts+1;
      }
   }
 }

 fclose(fp);
 printf("\n\n");
 /* 
for(i=0;i<npts;i=i+1){ 
   if (!strcmp(mode,"--monod")) 
       printf("range= %f beta_s=%f beta_m=%f r_eff=%f \n"
                ,ranges[i],beta_s[i],beta_m[i],r_eff[i]);

   else if (!strcmp(mode,"--lognm")) 
       printf("range= %f beta_s=%f beta_m=%f r_eff=%f gamma=%f \n"
                ,ranges[i],beta_s[i],beta_m[i],r_eff[i],gamma_local[i]);
 
	    else if (!strcmp(mode,"--gamma"))
        printf("range= %f beta_s=%f beta_m=%f r_eff=%f alpha=%f gamma=%f \n"
                ,ranges[i],beta_s[i],beta_m[i],r_eff[i],alpha[i],gamma_local[i]);
 }
 */

 /*prepare variables for integration routines*/
 /*find the array indices of start_range and end_range */
 if (start_range >= end_range){
   printf("\nERROR---'start_range' must be smaller than 'end_range'\n\n");
   usage();
   exit(7);
   }
 start_pt=0;
 last_pt=0;
 for(i=0;i<npts;i++){
   if(start_range >= ranges[i]) start_pt=i;
   if(end_range >= ranges[i]) last_pt=i;
   }
 if(start_pt==last_pt){
    printf("\n start_range and end_range specify an interval outside range of data in input file \n\n");
    exit(8);
 }
 printf("\nstart range=%f start_pt=%i end range=%f last_pt=%i\n",start_range,start_pt,end_range,last_pt);

 /*compute the aerosol optical depth, tau_c,and total optical depth, tau_t using a trapozodial integration*/
 tau_c[start_pt]=0;
 tau_t[start_pt]=0; 
 dr=ranges[2]-ranges[1];
 for(i=(start_pt+1);i<=last_pt;i++){
   tau_c[i]=tau_c[i-1]+dr*(beta_s[i-1]+beta_s[i])/2;
   tau_t[i]=tau_t[i-1]+dr*(beta_s[i-1]+beta_m[i-1]+beta_s[i]+beta_m[i])/2;
 }

 if(!strcmp(mode,"--lognm")){
     /*generate log-normal form of alpha*/
   for(i=0;i<npts;i++){
     ln_alpha[i]=r_eff[i]*exp(-2.5*pow(gamma_local[i],2));
     } 
   /*initialize the non-dimensional radius vector for log-normal case */
   /*particle size integral is summed over 17 equally space  radii */
   nu=17;
   for (i=0;i<=nu;i++){
     u[i]=-2.4+0.3*i;
     }
   }

/*Open output file and store header info*/

 if ((fp = fopen(output_file_name,"w"))==NULL) {
   printf("ERROR OPENING OUTPUT FILE '%s'\n",output_file_name);
     exit(9);
 }

 
 fprintf(fp,"#The following command string created this file\n#           mscat");
 for (i=1;i<argc;i++) fprintf(fp," %s",argv[i]);
 fprintf(fp,"\n");
 fprintf(fp,"# input data acquired from file '%s'\n",argv[1]);
 fprintf(fp,"# laser divergence, full-angle = %9.2e radians \n",laser_div);
 fprintf(fp,"# receiver diverence, full-angle = %9.2e radians  \n",receiver_fov);
 fprintf(fp,"# wavelength = %9.3f microns \n",lambda); 
 fprintf(fp,"# Multiple/single scatter ratios assume <P(180)>/P(180)=1  \n");
 fprintf(fp,"# pn/p1 ratios must be multipled by <P(180)>/P(180)...see App. Opt. V37 p2464-2474.\n"); 
 fprintf(fp,"# note--small negative values of pn/p1 may occur in regions of small scattering\n");
 fprintf(fp,"# due to trapizodial rule quadrature errors. These values are\n"); fprintf(fp,"# generally less than 0.01\n"); 
 fprintf(fp,"# sum is the sum the ratios p(n)/p1\n");
 fprintf(fp,"# tau_c is the integral of beta_s \n");
 fprintf(fp,"# Rayleigh is proportional to the r-squared corrected Rayleigh lidar return\n");
 fprintf(fp,"#  \n");


/*print column headings in output file*/
 strcpy(header1,"#range(m) p2/p1");
 strcpy(header2,"   tau_c  beta_s(1/m) beta_m(1/m) r_eff(um)");
 if (!strcmp(mode,"--monod")) strcpy(header3,"Rayleigh ");
 else if (!strcmp(mode,"--lognm")) strcpy(header3," gamma Rayleigh");
 else if (!strcmp(mode,"--gamma")) strcpy(header3," alpha    gamma Rayleigh");
/* fprintf(fp,head); fprintf(fp,'%s',lf); [nr,nc]=size(ms);*/
 if(norders==2){
    fprintf(fp,"%s    sum/p1 %s %s\n",header1,header2,header3); 
    }
 else if(norders==3){
    fprintf(fp,"%s    p3/p1      sum/p1 %s %s\n",header1,header2,header3); 
    }
 else if(norders==4){
    fprintf(fp,"%s    p3/p1     p4/p1      sum/p1 %s %s \n",header1,header2,header3); 
    }
 else if(norders==5){
    fprintf(fp,"%s    p3/p1     p4/p1     p5/p1      sum/p1 %s %s\n"
            ,header1,header2,header3);
    }
  else if(norders==6){
    fprintf(fp,"%s    p3/p1     p4/p1     p5/p1    p6/p1      sum/p1 %s %s\n"
            ,header1,header2,header3);
    }
else if(norders==7){
    fprintf(fp,"%s    p3/p1     p4/p1     p5/p1    p6/p1     p7/p1      sum/p1 %s %s\n",header1,header2,header3);
 
    }
 /*done storing header infomation in output file*/



  


   /* multiple scatter integral--this portion of the code does all the core work*/
   /* N = order of scattering*/
 if (!strcmp(mode,"--monod")){
    
    for (N=2;N<=norders;N++){
        /*loop over all ranges*/
       for (i=start_pt; i<=last_pt;i=i+inc){
	     divlr2=pow((M_PI*laser_div*ranges[i]/(2*lambda)),2);
             fovr2=pow((M_PI*receiver_fov*ranges[i]/(2*lambda)),2);
             
             ms[i][N]=ms_int_c(N,ranges,start_pt,i,beta_s,r_eff
               ,divlr2,fovr2);
             ms[i][N]=pow(tau_c[i],(N-1))/fact_m_one[N]-ms[i][N];
             printf("N=%i r= %7.1f ms= %9.2e\n",N,ranges[i],ms[i][N]);
            /* printf("N= %i r= %7.1f beta= %9.2e ln_alpha= %9.2e gam= %9.2e divlr2= %9.2e fovr2= %9.2e fov=%9.2e\n", N, ranges[i],beta_s[i],ln_alpha[i]
                   ,gamma_local[i],divlr2,fovr2,receiver_fov);*/
             } 
     }

 }
 else if (!strcmp(mode,"--lognm")){
   for (N=2;N<=norders;N++){
        /*loop over all ranges*/
       for (i=start_pt; i<=last_pt;i=i+inc){
	     divlr2=pow((M_PI*laser_div*ranges[i]/(2*lambda)),2);
             fovr2=pow((M_PI*receiver_fov*ranges[i]/(2*lambda)),2);
             ms[i][N]=ms_size_int_c(N,ranges,start_pt,i,beta_s,ln_alpha
                            ,gamma_local,nu,u,divlr2,fovr2);
             ms[i][N]=pow(tau_c[i],(N-1))/fact_m_one[N]-ms[i][N];
             printf("N=%i r= %7.1f ms= %9.2e\n",N,ranges[i],ms[i][N]);
            /* printf("N= %i r= %7.1f beta= %9.2e ln_alpha= %9.2e gam= %9.2e divlr2= %9.2e fovr2= %9.2e fov=%9.2e\n", N, ranges[i],beta_s[i],ln_alpha[i]
                   ,gamma_local[i],divlr2,fovr2,receiver_fov);*/
             } 
     }
 }


  /*store results in output file*/
 for (i=start_pt;i<=last_pt;i=i+inc){
    sum=0;
    fprintf(fp,"%07.1f ",ranges[i]);
    for(n=2;n<=norders;n++){
      sum=sum+ms[i][n];       
      Rayleigh=3*(1+sum)*beta_m[i]*exp(-2*tau_t[i])/(8*3.14159);  
      fprintf(fp,"%9.2e ",ms[i][n]);}
    if (!strcmp(mode,"--monod")){
      fprintf(fp,"%9.2e %9.2e %9.2e %9.2e %9.2e %9.2e\n",sum,tau_c[i],beta_s[i],beta_m[i],r_eff[i],Rayleigh);
      }
    else if (!strcmp(mode,"--lognm")){
      fprintf(fp,"%9.2e %9.2e %9.2e %9.2e %9.2e %9.2e %9.2e\n",sum,tau_c[i],beta_s[i],beta_m[i],r_eff[i],gamma_local[i]
           ,Rayleigh);
      }
    else if (!strcmp(mode,"--gamma")){
      fprintf(fp,"%9.2e %9.2e %9.2e %9.2e %9.2e %9.2e %9.2e %9.2e\n",sum,tau_c[i],beta_s[i],beta_m[i]
                    ,r_eff[i],alpha[i],gamma_local[i],Rayleigh);
      }
 }

 fprintf(fp,"\n"); 
 fclose(fp);
 return 0;
   }
 




 


