
/* computes multiple scattering ratios for quasi-monodisperse size distributions */
/* see App. Optics, Vol 37, p2464-2474     */
/* this routine calls itself recursively for each order of scattering*/
/* input parameters*/
/* n_th             = order of scattering                                */
/* first_pt         = index of data point at which to begin computation  */
/* divlR2           =(pi*FOVT*ranges(i)/lambda)^2                        */
/* ranges   = array of equally spaced ranges                     */
/* fovR2    =(pi*FOVR*ranges(i)/lambda)^2             */
/* last_pt  = index of last data point at which to compute mscat  */
/* r_eff    = array of effective radii at points specified in ranges */
/* beta_c   = array scattering cross sections at points specified in ranges*/


#include <stdlib.h>
#include <math.h>
#include <stdio.h>
struct state{
  double *ranges;
  int last_pt;
  double *beta_c;
  double *r_eff;
  double fovR2;
  double dr;
};


#ifdef DEBUG
#define DPRINTF(x...) printf(x)
#else
#define DPRINTF(x...) 
#endif


double md_rec_func(int n_th, int first_pt, double divlR2, struct state *tables){
  
  double ret=0.0;
  int npts=tables->last_pt-first_pt+1;
  int i;
  double *kern;
  double bksum=0.0;
  double rfac;
  kern=calloc(npts*sizeof(double),sizeof(double));

  if(n_th==2){
	for(i=first_pt;i<=tables->last_pt;i++){
	  rfac= (tables->ranges[tables->last_pt]-tables->ranges[i])/tables->r_eff[i];
	  DPRINTF ("rfac-1 = %f\n",rfac); 
	  bksum+=tables->beta_c[i]*(kern[i-first_pt]=exp(-tables->fovR2/(rfac*rfac+divlR2)));
 	  ret=tables->dr*(bksum-tables->beta_c[first_pt]*kern[0]/2-tables->beta_c[tables->last_pt]*kern[npts-1]/2);
	  DPRINTF ("returning %f\n",ret); 
          }
      }
      else{
	double s;
	for(i=first_pt;i<=tables->last_pt;i++){
          rfac= (tables->ranges[tables->last_pt]-tables->ranges[i])/tables->r_eff[i];
          s = divlR2 + rfac*rfac;
	  bksum+=tables->beta_c[i]*(kern[i-first_pt]=md_rec_func(n_th-1,i,s,tables));
          /*fprintf(stderr,"beta_c= %f n_th= %i i= %i s= %f r_eff= %f\n",tables->beta_c[i],n_th,i,s,tables->r_eff[i]);*/
	  }
	ret=tables->dr*(bksum-tables->beta_c[first_pt]*kern[0]/2-tables->beta_c[tables->last_pt]*kern[npts-1]/2);
        }

   free(kern);
  return ret;
}

double
ms_int_c (  int n_th, double *ranges, int first_pt, int last_pt, double *beta_c,
	       double *r_eff,  double divlr2, double fovr2){



     /*ms_size_int (  int n_th, double *ranges, int first_pt, int last_pt, double *beta_c,
	       double *r_eff, double *gamma_, int nu, double *u, double divlr2, double fovr2)*/

  double ret=0.0;
  struct state tables;
  
  DPRINTF ("Starting up");
  tables.ranges=ranges;
  tables.last_pt=last_pt;
  tables.beta_c = beta_c;
  tables.r_eff = r_eff;
  tables.fovR2 = fovr2;
  tables.dr=ranges[1]-ranges[0];

  DPRINTF (" - Working .."); 
	
  ret=md_rec_func(n_th, first_pt, divlr2,&tables);
  DPRINTF (" - Done\n"); 
  return ret;
}
